/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.api.manager;

import com.mumfrey.liteloader.api.CoreProvider;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.Observer;
import com.mumfrey.liteloader.api.manager.APIAdapter;
import com.mumfrey.liteloader.api.manager.APIProvider;
import com.mumfrey.liteloader.interfaces.InterfaceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

class APIProviderBasic
implements APIProvider,
APIAdapter {
    private final LiteAPI[] apis;
    private final Map<String, LiteAPI> apiMap = new HashMap<String, LiteAPI>();
    private final Map<LiteAPI, List<? extends Observer>> observers = new HashMap<LiteAPI, List<? extends Observer>>();
    private List<CoreProvider> coreProviders;

    APIProviderBasic(LiteAPI[] apis) {
        for (LiteAPI api : this.apis = apis) {
            this.apiMap.put(api.getIdentifier(), api);
        }
    }

    @Override
    public List<String> getRequiredTransformers() {
        ArrayList<String> requiredTransformers = new ArrayList<String>();
        for (LiteAPI api : this.apis) {
            String[] apiTransformers = api.getRequiredTransformers();
            if (apiTransformers == null) continue;
            requiredTransformers.addAll(Arrays.asList(apiTransformers));
        }
        return requiredTransformers;
    }

    @Override
    public List<String> getRequiredDownstreamTransformers() {
        ArrayList<String> requiredDownstreamTransformers = new ArrayList<String>();
        for (LiteAPI api : this.apis) {
            String[] apiTransformers = api.getRequiredDownstreamTransformers();
            if (apiTransformers == null) continue;
            requiredDownstreamTransformers.addAll(Arrays.asList(apiTransformers));
        }
        return requiredDownstreamTransformers;
    }

    @Override
    public List<String> getPacketTransformers() {
        ArrayList<String> packetTransformers = new ArrayList<String>();
        for (LiteAPI api : this.apis) {
            String[] apiTransformers = api.getPacketTransformers();
            if (apiTransformers == null) continue;
            packetTransformers.addAll(Arrays.asList(apiTransformers));
        }
        return packetTransformers;
    }

    @Override
    public List<? extends Observer> getObservers(LiteAPI api) {
        if (!this.observers.containsKey(api)) {
            ArrayList apiObservers = api.getObservers();
            this.observers.put(api, Collections.unmodifiableList(apiObservers != null ? apiObservers : new ArrayList()));
        }
        return this.observers.get(api);
    }

    @Override
    public <T extends Observer> List<T> getObservers(LiteAPI api, Class<T> observerType) {
        ArrayList<Observer> matchingObservers = new ArrayList<Observer>();
        for (Observer observer : this.getObservers(api)) {
            if (!observerType.isAssignableFrom(observer.getClass()) || matchingObservers.contains(observer)) continue;
            matchingObservers.add(observer);
        }
        return matchingObservers;
    }

    @Override
    public <T extends Observer> List<T> getAllObservers(Class<T> observerType) {
        ArrayList<Object> matchingObservers = new ArrayList<Object>();
        for (LiteAPI api : this.apis) {
            matchingObservers.addAll(this.getObservers(api, observerType));
        }
        for (CoreProvider coreProvider : this.getCoreProviders()) {
            if (!observerType.isAssignableFrom(coreProvider.getClass()) || matchingObservers.contains(coreProvider)) continue;
            matchingObservers.add(coreProvider);
        }
        return matchingObservers;
    }

    @Override
    public void registerInterfaces(InterfaceRegistry interfaceManager) {
        for (LiteAPI api : this.apis) {
            interfaceManager.registerAPI(api);
        }
    }

    @Override
    public List<CoreProvider> getCoreProviders() {
        if (this.coreProviders == null) {
            ArrayList<CoreProvider> coreProviders = new ArrayList<CoreProvider>();
            for (LiteAPI api : this.apis) {
                List<CoreProvider> apiCoreProviders = api.getCoreProviders();
                if (apiCoreProviders == null) continue;
                coreProviders.addAll(apiCoreProviders);
            }
            this.coreProviders = Collections.unmodifiableList(coreProviders);
        }
        return this.coreProviders;
    }

    @Override
    public LiteAPI[] getAPIs() {
        return this.apis;
    }

    @Override
    public boolean isAPIAvailable(String identifier) {
        Matcher idAndRevisionPatternMatcher;
        if (identifier != null && identifier.contains("@") && (idAndRevisionPatternMatcher = APIProvider.idAndRevisionPattern.matcher(identifier)).matches()) {
            return this.isAPIAvailable(idAndRevisionPatternMatcher.group(1), Integer.parseInt(idAndRevisionPatternMatcher.group(2)));
        }
        return this.apiMap.containsKey(identifier);
    }

    @Override
    public boolean isAPIAvailable(String identifier, int minRevision) {
        LiteAPI api = this.apiMap.get(identifier);
        if (api == null) {
            return false;
        }
        return api.getRevision() >= minRevision;
    }

    @Override
    public LiteAPI getAPI(String identifier) {
        return this.apiMap.get(identifier);
    }

    @Override
    public <T extends LiteAPI> T getAPI(Class<T> apiClass) {
        try {
            for (LiteAPI api : this.apis) {
                if (!apiClass.isAssignableFrom(api.getClass())) continue;
                return (T)api;
            }
        }
        catch (NullPointerException ex1) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }
}

