/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.lists.CanvasSearch;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.core.BetterQuesting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class CanvasItemDatabase
extends CanvasSearch<ItemStack, Item> {
    private final int btnId;

    public CanvasItemDatabase(IGuiRect rect, int buttonId) {
        super(rect);
        this.btnId = buttonId;
    }

    @Override
    protected Iterator<Item> getIterator() {
        return Item.field_150901_e.iterator();
    }

    @Override
    protected void queryMatches(Item item, String query, ArrayDeque<ItemStack> results) {
        if (item == null) {
            return;
        }
        String regName = Item.field_150901_e.func_148750_c((Object)item);
        if (regName == null) {
            return;
        }
        try {
            ArrayList<ItemStack> subList = new ArrayList<ItemStack>();
            item.func_150895_a(item, CreativeTabs.field_78027_g, subList);
            if (subList.isEmpty()) {
                subList.add(new ItemStack(item));
            }
            if (regName.toLowerCase().contains(query) || item.func_77658_a().toLowerCase().contains(query) || QuestTranslation.translate(item.func_77658_a(), new Object[0]).toLowerCase().contains(query)) {
                results.addAll(subList);
                return;
            }
            subList.parallelStream().forEach(subItem -> {
                try {
                    if (subItem.func_77977_a().toLowerCase().contains(query) || subItem.func_82833_r().toLowerCase().contains(query)) {
                        results.add((ItemStack)subItem);
                    } else if (Arrays.stream(OreDictionary.getOreIDs((ItemStack)subItem)).anyMatch(id -> OreDictionary.getOreName((int)id).toLowerCase().contains(query))) {
                        results.add((ItemStack)subItem);
                    }
                }
                catch (Exception e) {
                    BetterQuesting.logger.error("An error occured while searching itemstack " + subItem.toString() + " from item \"" + regName + "\" (" + item.getClass().getName() + ").\nNBT: " + subItem.func_77955_b(new NBTTagCompound()), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            BetterQuesting.logger.error("An error occured while searching item \"" + regName + "\" (" + item.getClass().getName() + ")", (Throwable)e);
        }
    }

    @Override
    public boolean addResult(ItemStack stack, int index, int cachedWidth) {
        if (stack == null) {
            return false;
        }
        int x = index % (cachedWidth / 18) * 18;
        int y = index / (cachedWidth / 18) * 18;
        this.addPanel(new PanelItemSlot((IGuiRect)new GuiRectangle(x, y, 18, 18, 0), this.btnId, new BigItemStack(stack)));
        return true;
    }
}

