/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.ConfigUtils;
import com.gitlab.cdagaming.craftpresence.config.gui.MainGui;
import com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.settings.KeyBinding;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class KeyUtils {
    private final List<Integer> invalidKeys = Lists.newArrayList((Object[])new Integer[]{1, 256});
    private final Map<String, Tuple<KeyBinding, Runnable, DataConsumer<Throwable>>> KEY_MAPPINGS = Maps.newHashMap();

    void register() {
        this.KEY_MAPPINGS.put("configKeyCode", new Tuple<KeyBinding, Runnable, Object>(new KeyBinding("key.craftpresence.config_keycode.name", CraftPresence.CONFIG.configKeyCode, "key.craftpresence.category"), () -> {
            if (!CraftPresence.GUIS.isFocused && !CraftPresence.GUIS.configGUIOpened) {
                CraftPresence.GUIS.openScreen(new MainGui(CraftPresence.instance.field_71462_r));
            }
        }, null));
        for (String keyName : this.KEY_MAPPINGS.keySet()) {
            CraftPresence.instance.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.add((Object[])CraftPresence.instance.field_71474_y.field_74324_K, (Object)this.KEY_MAPPINGS.get(keyName).getFirst());
        }
    }

    public boolean isValidKeyCode(int sourceKeyCode) {
        return !this.invalidKeys.contains(sourceKeyCode);
    }

    public String getKeyName(String original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pair<Boolean, Integer> integerData = StringUtils.getValidInteger(original);
            if (integerData.getFirst().booleanValue()) {
                return this.getKeyName(integerData.getSecond());
            }
            return unknownKeyName;
        }
        return unknownKeyName;
    }

    public String getKeyName(int original) {
        String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
        if (this.isValidKeyCode(original)) {
            if (ModUtils.MCProtocolID <= 340 && KeyConverter.toGlfw.containsKey(original)) {
                return KeyConverter.toGlfw.get(original).getSecond();
            }
            if (ModUtils.MCProtocolID > 340 && KeyConverter.fromGlfw.containsKey(original)) {
                return KeyConverter.fromGlfw.get(original).getSecond();
            }
            String keyName = Keyboard.getKeyName((int)original);
            if (!StringUtils.isNullOrEmpty(keyName)) {
                return keyName;
            }
            return Integer.toString(original);
        }
        return unknownKeyName;
    }

    void onTick() {
        block9: {
            if (Keyboard.isCreated() && CraftPresence.CONFIG != null) {
                String unknownKeyName = (ModUtils.MCProtocolID <= 340 ? KeyConverter.fromGlfw.get(-1) : KeyConverter.toGlfw.get(0)).getSecond();
                try {
                    for (String keyName : this.KEY_MAPPINGS.keySet()) {
                        KeyBinding keyBind = this.KEY_MAPPINGS.get(keyName).getFirst();
                        if (!this.getKeyName(keyBind.func_151463_i()).equals(unknownKeyName) && Keyboard.isKeyDown((int)keyBind.func_151463_i()) && !(CraftPresence.instance.field_71462_r instanceof GuiControls)) {
                            Tuple<KeyBinding, Runnable, DataConsumer<Throwable>> keyData = this.KEY_MAPPINGS.get(keyName);
                            try {
                                keyData.getSecond().run();
                            }
                            catch (Error | Exception ex) {
                                if (keyData.getThird() != null) {
                                    keyData.getThird().accept(ex);
                                    continue;
                                }
                                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.keycode", keyBind.func_151464_g()), new Object[0]);
                                this.syncKeyData(keyName, ImportMode.Specific, keyBind.func_151469_h());
                            }
                            continue;
                        }
                        if (CraftPresence.CONFIG.hasChanged) continue;
                        if (CraftPresence.CONFIG.keySyncQueue.containsKey(keyName)) {
                            this.syncKeyData(keyName, ImportMode.Config, CraftPresence.CONFIG.keySyncQueue.get(keyName));
                            CraftPresence.CONFIG.keySyncQueue.remove(keyName);
                            continue;
                        }
                        if (keyBind.func_151463_i() == StringUtils.getValidInteger(StringUtils.lookupObject(ConfigUtils.class, CraftPresence.CONFIG, keyName)).getSecond().intValue()) continue;
                        this.syncKeyData(keyName, ImportMode.Vanilla, keyBind.func_151463_i());
                    }
                }
                catch (Error | Exception ex) {
                    if (!ModUtils.IS_VERBOSE) break block9;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        Tuple keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            ((KeyBinding)keyData.getFirst()).func_151462_b(keyCode);
        } else if (mode == ImportMode.Vanilla) {
            StringUtils.updateField(ConfigUtils.class, CraftPresence.CONFIG, new Tuple<String, Integer, Object>(keyName, keyCode, null));
            CraftPresence.CONFIG.updateConfig(false);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(((KeyBinding)keyData.getFirst()).func_151464_g(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        } else if (ModUtils.IS_VERBOSE) {
            ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.convert.invalid", keyName, mode.name()), new Object[0]);
        }
    }

    public Map<String, Tuple<KeyBinding, Runnable, DataConsumer<Throwable>>> getKeyMappings(FilterMode mode, List<String> filterData) {
        HashMap filteredMappings = Maps.newHashMap();
        for (String keyName : this.KEY_MAPPINGS.keySet()) {
            if (mode != FilterMode.None && mode != FilterMode.Category && mode != FilterMode.Id && (mode != FilterMode.Name || !filterData.contains(keyName))) continue;
            Tuple<KeyBinding, Runnable, DataConsumer<Throwable>> keyData = this.KEY_MAPPINGS.get(keyName);
            if (!(mode == FilterMode.None || mode == FilterMode.Category && filterData.contains(keyData.getFirst().func_151466_e()) || mode == FilterMode.Id && filterData.contains(keyData.getFirst().func_151464_g())) && mode != FilterMode.Name) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, Tuple<KeyBinding, Runnable, DataConsumer<Throwable>>> getKeyMappings() {
        return this.getKeyMappings(FilterMode.None, Lists.newArrayList());
    }

    public static enum FilterMode {
        Category,
        Name,
        Id,
        None;

    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }
}

