/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.config.ConfigUtils;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.SystemUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.DiscordUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import com.gitlab.cdagaming.craftpresence.utils.server.ServerUtils;
import com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import com.gitlab.cdagaming.craftpresence.utils.world.DimensionUtils;
import cpw.mods.fml.common.Mod;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

@Mod(modid="craftpresence", name="CraftPresence", version="1.8.1", guiFactory="com.gitlab.cdagaming.craftpresence.config.ConfigGuiDataFactory", canBeDeactivated=true, certificateFingerprint="eca02c6a597321ad22340897683951ba5c76720a", acceptedMinecraftVersions="*")
public class CraftPresence {
    public static boolean packFound = false;
    public static boolean closing = false;
    public static Timer timerObj = new Timer(CraftPresence.class.getSimpleName());
    public static Minecraft instance = Minecraft.func_71410_x();
    public static EntityPlayer player = CraftPresence.instance.field_71439_g;
    public static ConfigUtils CONFIG;
    public static SystemUtils SYSTEM;
    public static KeyUtils KEYBINDINGS;
    public static DiscordUtils CLIENT;
    public static ServerUtils SERVER;
    public static BiomeUtils BIOMES;
    public static DimensionUtils DIMENSIONS;
    public static EntityUtils ENTITIES;
    public static TileEntityUtils TILE_ENTITIES;
    public static GuiUtils GUIS;
    public static boolean isDevStatusOverridden;
    public static boolean isVerboseStatusOverridden;
    private boolean initialized = false;

    public CraftPresence() {
        this.scheduleTick();
    }

    private void init() {
        ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.warning.debug_mode", new Object[0]), new Object[0]);
        ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.os", CraftPresence.SYSTEM.OS_NAME, CraftPresence.SYSTEM.OS_ARCH, CraftPresence.SYSTEM.IS_64_BIT), new Object[0]);
        ModUtils.UPDATER.checkForUpdates(() -> {
            if (ModUtils.UPDATER.isInvalidVersion) {
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_ID", "v" + ModUtils.UPDATER.targetVersion, -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_TYPE", ModUtils.UPDATER.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_LABEL", ModUtils.UPDATER.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("NAME", CraftPresence.class.getSimpleName(), -17));
                ModUtils.UPDATER.currentVersion = ModUtils.UPDATER.targetVersion;
                ModUtils.UPDATER.isInvalidVersion = false;
            }
        });
        SYSTEM = new SystemUtils();
        CONFIG = new ConfigUtils(ModUtils.configDir + File.separator + "craftpresence" + ".properties");
        CONFIG.initialize();
        File CP_DIR = new File("craftpresence");
        ModUtils.loadCharData(!CP_DIR.exists() || CP_DIR.listFiles() == null, "UTF-8");
        CommandUtils.init();
        if (!ModUtils.IS_DEV) {
            ModUtils.IS_DEV = CraftPresence.CONFIG.debugMode || ModUtils.IS_VERBOSE;
        } else {
            isDevStatusOverridden = true;
        }
        if (!ModUtils.IS_VERBOSE) {
            ModUtils.IS_VERBOSE = CraftPresence.CONFIG.verboseMode;
        } else {
            isVerboseStatusOverridden = true;
        }
        try {
            CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.clientId;
            CraftPresence.CLIENT.AUTO_REGISTER = CraftPresence.CONFIG.autoRegister;
            CLIENT.setup();
            CLIENT.init(true);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.load", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            this.initialized = true;
        }
    }

    private void scheduleTick() {
        if (!closing) {
            timerObj.schedule(new TimerTask(){

                @Override
                public void run() {
                    CraftPresence.this.clientTick();
                }
            }, 50L);
        }
    }

    private void clientTick() {
        if (!closing) {
            if (this.initialized) {
                instance = Minecraft.func_71410_x();
                player = CraftPresence.instance.field_71439_g;
                ModUtils.IS_DEV = !isDevStatusOverridden ? CraftPresence.CONFIG.debugMode : ModUtils.IS_DEV;
                ModUtils.IS_VERBOSE = !isVerboseStatusOverridden ? CraftPresence.CONFIG.verboseMode : ModUtils.IS_VERBOSE;
                CommandUtils.reloadData(false);
                if (!CraftPresence.CONFIG.hasChanged) {
                    if (!CraftPresence.SYSTEM.HAS_LOADED) {
                        CommandUtils.setLoadingPresence();
                    } else if (!(CommandUtils.isInMainMenu || CraftPresence.DIMENSIONS.isInUse || CraftPresence.BIOMES.isInUse || CraftPresence.TILE_ENTITIES.isInUse || CraftPresence.ENTITIES.isInUse || CraftPresence.SERVER.isInUse)) {
                        CommandUtils.setMainMenuPresence();
                    } else if (player != null && (CommandUtils.isLoadingGame || CommandUtils.isInMainMenu)) {
                        CommandUtils.isInMainMenu = false;
                        CommandUtils.isLoadingGame = false;
                        CLIENT.initArgument("&MAINMENU&");
                    }
                    if (CraftPresence.SYSTEM.HAS_LOADED) {
                        if (CraftPresence.CLIENT.awaitingReply && CraftPresence.SYSTEM.TIMER == 0) {
                            StringUtils.sendMessageToPlayer((Entity)player, ModUtils.TRANSLATOR.translate("craftpresence.command.request.ignored", CraftPresence.CLIENT.REQUESTER_USER.getName()));
                            CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY, null);
                            CraftPresence.CLIENT.awaitingReply = false;
                            CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                        } else if (!CraftPresence.CLIENT.awaitingReply && CraftPresence.CLIENT.REQUESTER_USER != null) {
                            CraftPresence.CLIENT.REQUESTER_USER = null;
                            CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                        }
                    }
                }
            } else {
                this.init();
            }
            this.scheduleTick();
        }
    }

    static {
        SYSTEM = new SystemUtils();
        KEYBINDINGS = new KeyUtils();
        CLIENT = new DiscordUtils();
        SERVER = new ServerUtils();
        BIOMES = new BiomeUtils();
        DIMENSIONS = new DimensionUtils();
        ENTITIES = new EntityUtils();
        TILE_ENTITIES = new TileEntityUtils();
        GUIS = new GuiUtils();
        isDevStatusOverridden = false;
        isVerboseStatusOverridden = false;
    }
}

