/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.mod.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import me.otho.customItems.mod.items.CustomSeed;
import me.otho.customItems.utility.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CustomCrop
extends BlockCrops {
    private String fruit;
    private Item seed;
    private boolean dropSeedWhenMature;
    private boolean acceptBoneMeal;
    private int minFruitDrop;
    private int maxFruitDrop;
    private int eachExtraFruitDropChance;
    private int minSeedDrop;
    private int maxSeedDrop;
    private int eachExtraSeedDropChance;
    private IIcon[] icons;
    private int renderType;
    private int dropFruitDamage;

    public CustomCrop(String fruit, int renderType) {
        this.fruit = fruit;
        this.renderType = renderType;
        this.func_149647_a(null);
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        if (this.acceptBoneMeal) {
            return p_149851_1_.func_72805_g(p_149851_2_, p_149851_3_, p_149851_4_) != 7;
        }
        return false;
    }

    private int getFruitDropQuantity(World world, int fortune) {
        int ret = 0;
        for (int i = 0; i < this.maxFruitDrop + fortune; ++i) {
            boolean willDrop;
            boolean bl = willDrop = world.field_73012_v.nextInt(100) < this.eachExtraFruitDropChance;
            if (!willDrop) continue;
            ++ret;
        }
        if (ret < this.minFruitDrop) {
            ret = this.minFruitDrop;
        }
        return ret;
    }

    private int getSeedDropQuantity(World world, int fortune) {
        int ret = 0;
        ret = this.minSeedDrop;
        for (int i = this.minSeedDrop; i < this.maxSeedDrop + fortune; ++i) {
            boolean willDrop;
            boolean bl = willDrop = world.field_73012_v.nextInt(100) < this.eachExtraSeedDropChance;
            if (!willDrop) continue;
            ++ret;
        }
        return ret;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int seedQuantity = this.getSeedDropQuantity(world, fortune);
        int fruitQuantity = this.getFruitDropQuantity(world, fortune);
        if (metadata < 7) {
            drops.add(new ItemStack(this.seed));
        } else {
            String[] parser = this.fruit.split(":");
            Item item = GameRegistry.findItem((String)parser[0], (String)parser[1]);
            int damage = parser.length > 2 ? Integer.parseInt(parser[2]) : 0;
            if (fruitQuantity > 0) {
                drops.add(new ItemStack(item, fruitQuantity, damage));
            }
            if (this.dropSeedWhenMature && seedQuantity > 0) {
                drops.add(new ItemStack(this.seed, seedQuantity, this.dropFruitDamage));
            }
        }
        return drops;
    }

    public void setAcceptBoneMeal(boolean acceptBoneMeal) {
        this.acceptBoneMeal = acceptBoneMeal;
    }

    public void setEachExtraFruitDropChance(int eachExtraFruitDropChance) {
        this.eachExtraFruitDropChance = eachExtraFruitDropChance;
    }

    public void setEachExtraSeedDropChance(int eachExtraSeedDropChance) {
        this.eachExtraSeedDropChance = eachExtraSeedDropChance;
    }

    public void setDropSeedWhenMature(boolean bool) {
        this.dropSeedWhenMature = bool;
    }

    public void setFruitQuantityDropRange(int min, int max) {
        if (min <= 0) {
            min = 0;
        }
        if (max < min) {
            max = min;
        }
        this.maxFruitDrop = max;
        this.minFruitDrop = min;
    }

    public void setSeedQuantityDropRange(int min, int max) {
        if (min <= 0) {
            min = 0;
        }
        if (max < min) {
            max = min;
        }
        this.maxSeedDrop = max;
        this.minSeedDrop = min;
    }

    public void setSeed(CustomSeed seed) {
        this.seed = seed;
    }

    protected Item func_149866_i() {
        return this.seed;
    }

    protected Item func_149865_P() {
        String[] parser = this.fruit.split(":");
        Item item = GameRegistry.findItem((String)parser[0], (String)parser[1]);
        return item;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return soil instanceof BlockFarmland;
    }

    public int func_149645_b() {
        return this.renderType;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        LogHelper.debug("registering icon for: " + this.func_149739_a());
        this.icons = new IIcon[4];
        for (int i = 1; i < this.icons.length + 1; ++i) {
            this.icons[i - 1] = iconRegister.func_94245_a("customitems".toLowerCase() + ":" + this.field_149768_d + i);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.icons[0];
            }
            case 1: {
                return this.icons[0];
            }
            case 2: {
                return this.icons[1];
            }
            case 3: {
                return this.icons[1];
            }
            case 4: {
                return this.icons[1];
            }
            case 5: {
                return this.icons[2];
            }
            case 6: {
                return this.icons[2];
            }
            case 7: {
                return this.icons[3];
            }
        }
        return this.icons[(int)Math.floor(meta / 5)];
    }

    public void setFruitItemDamage(int dropFruitDamage) {
        this.dropFruitDamage = dropFruitDamage;
    }
}

