/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.configuration;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import me.otho.customItems.configuration.ForgeConfig;
import me.otho.customItems.configuration.JsonSchema;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_block;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_blockDrop;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_crop;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_fluid;
import me.otho.customItems.configuration.jsonReaders.common.Cfg_creativeTab;
import me.otho.customItems.configuration.jsonReaders.entities.Cfg_entityDrop;
import me.otho.customItems.configuration.jsonReaders.items.Cfg_item;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_boots;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_chestplate;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_helmet;
import me.otho.customItems.configuration.jsonReaders.items.armor.Cfg_leggings;
import me.otho.customItems.configuration.jsonReaders.items.food.Cfg_food;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_axe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_hoe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_pickaxe;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_shovel;
import me.otho.customItems.configuration.jsonReaders.items.tools.Cfg_sword;
import me.otho.customItems.configuration.jsonReaders.tileEntity.Cfg_chest;
import me.otho.customItems.configuration.jsonReaders.tweakers.Cfg_change_block;
import me.otho.customItems.configuration.jsonReaders.tweakers.Cfg_change_food;
import me.otho.customItems.configuration.jsonReaders.tweakers.Cfg_change_item;
import me.otho.customItems.configuration.jsonReaders.worldGen.Cfg_oreGen;
import me.otho.customItems.registry.Registry;
import me.otho.customItems.utility.LogHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

public class JsonConfigurationHandler {
    public static JsonSchema data;
    public static JsonSchema allData;

    public static void init(String folderPath, File source) throws IOException {
        if (ForgeConfig.remake) {
            JsonConfigurationHandler.remakeConfigFiles(source, folderPath);
        }
        File folder = new File(folderPath);
        allData = new JsonSchema();
        if (folder.exists()) {
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles.length > 0) {
                Gson gson = new Gson();
                for (int i = 0; i < listOfFiles.length; ++i) {
                    File file = listOfFiles[i];
                    if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                    try {
                        JsonReader reader = new JsonReader((Reader)new FileReader(file));
                        LogHelper.info("Reading json file:" + file.getName());
                        JsonSchema data = (JsonSchema)gson.fromJson(reader, JsonSchema.class);
                        JsonConfigurationHandler.mergeGson(data, allData);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (listOfFiles.length > 0) {
                    Registry.register(allData);
                }
            }
        } else {
            folder.mkdir();
        }
    }

    public static void post_init() {
        Registry.change(allData);
    }

    private static void mergeGson(JsonSchema data, JsonSchema mergeTo) {
        mergeTo.blocks = (Cfg_block[])ArrayUtils.addAll((Object[])data.blocks, (Object[])mergeTo.blocks);
        mergeTo.chests = (Cfg_chest[])ArrayUtils.addAll((Object[])data.chests, (Object[])mergeTo.chests);
        mergeTo.items = (Cfg_item[])ArrayUtils.addAll((Object[])data.items, (Object[])mergeTo.items);
        mergeTo.foods = (Cfg_food[])ArrayUtils.addAll((Object[])data.foods, (Object[])mergeTo.foods);
        mergeTo.pickaxes = (Cfg_pickaxe[])ArrayUtils.addAll((Object[])data.pickaxes, (Object[])mergeTo.pickaxes);
        mergeTo.axes = (Cfg_axe[])ArrayUtils.addAll((Object[])data.axes, (Object[])mergeTo.axes);
        mergeTo.shovels = (Cfg_shovel[])ArrayUtils.addAll((Object[])data.shovels, (Object[])mergeTo.shovels);
        mergeTo.hoes = (Cfg_hoe[])ArrayUtils.addAll((Object[])data.hoes, (Object[])mergeTo.hoes);
        mergeTo.swords = (Cfg_sword[])ArrayUtils.addAll((Object[])data.swords, (Object[])mergeTo.swords);
        mergeTo.helmets = (Cfg_helmet[])ArrayUtils.addAll((Object[])data.helmets, (Object[])mergeTo.helmets);
        mergeTo.chestplates = (Cfg_chestplate[])ArrayUtils.addAll((Object[])data.chestplates, (Object[])mergeTo.chestplates);
        mergeTo.leggings = (Cfg_leggings[])ArrayUtils.addAll((Object[])data.leggings, (Object[])mergeTo.leggings);
        mergeTo.boots = (Cfg_boots[])ArrayUtils.addAll((Object[])data.boots, (Object[])mergeTo.boots);
        mergeTo.fluids = (Cfg_fluid[])ArrayUtils.addAll((Object[])data.fluids, (Object[])mergeTo.fluids);
        mergeTo.creativeTabs = (Cfg_creativeTab[])ArrayUtils.addAll((Object[])data.creativeTabs, (Object[])mergeTo.creativeTabs);
        mergeTo.crops = (Cfg_crop[])ArrayUtils.addAll((Object[])data.crops, (Object[])mergeTo.crops);
        mergeTo.changeBlocks = (Cfg_change_block[])ArrayUtils.addAll((Object[])data.changeBlocks, (Object[])mergeTo.changeBlocks);
        mergeTo.changeItems = (Cfg_change_item[])ArrayUtils.addAll((Object[])data.changeItems, (Object[])mergeTo.changeItems);
        mergeTo.changeFoods = (Cfg_change_food[])ArrayUtils.addAll((Object[])data.changeFoods, (Object[])mergeTo.changeFoods);
        mergeTo.oreGen = (Cfg_oreGen[])ArrayUtils.addAll((Object[])data.oreGen, (Object[])mergeTo.oreGen);
        mergeTo.entitiesDrop = (Cfg_entityDrop[])ArrayUtils.addAll((Object[])data.entitiesDrop, (Object[])mergeTo.entitiesDrop);
        mergeTo.blocksDrop = (Cfg_blockDrop[])ArrayUtils.addAll((Object[])data.blocksDrop, (Object[])mergeTo.blocksDrop);
    }

    public static void remakeConfigFiles(File source, String configFolderPath) throws IOException {
        if (source.isFile()) {
            JarFile file = new JarFile(source);
            ZipEntry defaultConfigs = file.getEntry("defaultConfigs/");
            Enumeration<JarEntry> e = file.entries();
            while (e.hasMoreElements()) {
                String fileName;
                String[] parser;
                ZipEntry entry = e.nextElement();
                if (!entry.getName().contains("defaultConfigs/") || (parser = entry.getName().split("defaultConfigs/")).length <= 1 || !(fileName = parser[1]).endsWith(".json")) continue;
                File configFile = new File(configFolderPath + parser[1]);
                if (configFile.exists()) {
                    configFile.delete();
                }
                InputStream is = file.getInputStream(entry);
                InputStreamReader isr = new InputStreamReader(is);
                char[] buffer = new char[1];
                while (isr.read(buffer, 0, buffer.length) != -1) {
                    String s = new String(buffer);
                    FileUtils.write((File)configFile, (CharSequence)s, (boolean)true);
                }
            }
            LogHelper.info("End of Default Config Files");
            file.close();
        }
    }
}

