/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdWrap
extends WBCmd {
    public CmdWrap() {
        this.permission = "wrap";
        this.name = "wrap";
        this.minParams = 1;
        this.maxParams = 2;
        this.addCmdExample(this.nameEmphasized() + "{world} <on|off> - can make border crossings wrap.");
        this.helpText = "When border wrapping is enabled for a world, players will be sent around to the opposite edge of the border when they cross it instead of being knocked back. [world] is optional for players and defaults to the world the player is in.";
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        if (player == null && params.size() == 1) {
            this.sendErrorAndHelp(sender, "When running this command from console, you must specify a world.");
            return;
        }
        boolean wrap = false;
        if (params.size() == 2) {
            worldName = params.get(0);
            wrap = this.strAsBool(params.get(1));
        } else {
            worldName = Worlds.getWorldName(player.field_70170_p);
            wrap = this.strAsBool(params.get(0));
        }
        BorderData border = Config.Border(worldName);
        if (border == null) {
            this.sendErrorAndHelp(sender, "This world (\"" + worldName + "\") does not have a border set.");
            return;
        }
        border.setWrapping(wrap);
        Config.setBorder(worldName, border, false);
        Util.chat(sender, "Border for world \"" + worldName + "\" is now set to " + (wrap ? "" : "not ") + "wrap around.", new Object[0]);
    }
}

