/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.transport;

import cofh.lib.network.ByteBufHelper;
import cofh.lib.transport.IEnderChannelRegistry;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientEnderChannelRegistry
implements IEnderChannelRegistry {
    private TIntObjectHashMap<String> channel = new TIntObjectHashMap();
    private ArrayList<IEnderChannelRegistry.Frequency> list = new ArrayList();
    private int modCount;
    protected String hostedChannel = "";

    public void readFrequencyData(ByteBuf data) {
        ++this.modCount;
        this.channel.clear();
        this.list.clear();
        int size = ByteBufHelper.readVarInt(data);
        this.hostedChannel = ByteBufHelper.readString(data);
        for (int i = 0; i < size; ++i) {
            int freq = ByteBufHelper.readVarInt(data);
            String name = ByteBufHelper.readString(data);
            this.channel.put(freq, (Object)name);
            this.list.add(new IEnderChannelRegistry.Frequency(freq, name));
        }
        Collections.sort(this.list);
    }

    public String getChannelName() {
        return this.hostedChannel;
    }

    @Override
    public List<IEnderChannelRegistry.Frequency> getFrequencyList(String _) {
        return this.list;
    }

    @Override
    public String getFrequency(String _, int freq) {
        return (String)this.channel.get(freq);
    }

    @Override
    public String setFrequency(String _, int freq, String name) {
        ++this.modCount;
        IEnderChannelRegistry.Frequency f = new IEnderChannelRegistry.Frequency(freq, name);
        int i = this.list.indexOf(f);
        if (i < 0) {
            this.list.add(f);
            Collections.sort(this.list);
        } else {
            this.list.set(i, f);
        }
        return (String)this.channel.put(freq, (Object)name);
    }

    @Override
    public String removeFrequency(String _, int freq) {
        ++this.modCount;
        this.list.remove(new IEnderChannelRegistry.Frequency(freq, ""));
        return (String)this.channel.remove(freq);
    }

    @Override
    public int updated() {
        return this.modCount;
    }
}

