/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.ProgressDisplayer;
import alexiil.mods.load.Translation;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

public class ModLoadingListener {
    private static List<ModLoadingListener> listeners = new ArrayList<ModLoadingListener>();
    private static ModStage stage = null;
    private final ModContainer mod;

    public ModLoadingListener(ModContainer mod) {
        this.mod = mod;
        if (listeners.isEmpty()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        listeners.add(this);
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        ModLoadingListener.doProgress(State.CONSTRUCT, this);
    }

    @Subscribe
    public void preinit(FMLPreInitializationEvent event) {
        ModLoadingListener.doProgress(State.PRE_INIT, this);
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        ModLoadingListener.doProgress(State.INIT, this);
    }

    @Subscribe
    public void postinit(FMLPostInitializationEvent event) {
        ModLoadingListener.doProgress(State.POST_INIT, this);
    }

    @Subscribe
    public void loadComplete(FMLLoadCompleteEvent event) {
        ModLoadingListener.doProgress(State.LOAD_COMPLETE, this);
    }

    public static void doProgress(State state, ModLoadingListener mod) {
        if (stage == null) {
            stage = mod == null ? new ModStage(state, 0) : new ModStage(state, listeners.indexOf(mod));
        }
        String text = stage.getDisplayText();
        float percent = stage.getProgress() / 100.0f;
        stage = stage.getNext();
        if (ModLoadingListener.stage.state == State.FINAL_LOADING) {
            text = stage.getDisplayText();
            percent = stage.getProgress() / 100.0f;
        }
        ProgressDisplayer.displayProgress(text, percent);
    }

    private static class ModStage {
        public final State state;
        public final int index;

        public String toString() {
            return "ModStage [state=" + (Object)((Object)this.state) + ", index=" + this.index + "]";
        }

        public ModStage(State state, int index) {
            this.state = state;
            this.index = index;
        }

        public ModStage getNext() {
            int ind = this.index + 1;
            State s = this.state;
            if (ind == listeners.size() || s.isLoneState) {
                ind = 0;
                int ord = s.ordinal() + 1;
                if (ord == State.values().length) {
                    return null;
                }
                s = State.values()[ord];
                if (s.shouldSkip) {
                    return new ModStage(s, ind).getNext();
                }
            }
            return new ModStage(s, ind);
        }

        public String getDisplayText() {
            if (this.state.isLoneState) {
                return this.state.translate();
            }
            return this.state.translate() + ": " + Translation.translate("betterloadingscreen.loading", "loading") + " " + ((ModLoadingListener)listeners.get(this.index)).mod.getName();
        }

        public float getProgress() {
            float values = 100.0f / (float)State.values().length;
            float part = (float)this.state.ordinal() * values;
            float size = listeners.size();
            float percent = values * (float)this.index / size;
            return part + percent;
        }
    }

    public static enum State {
        CONSTRUCT("construction"),
        PRE_INIT("pre_initialization"),
        LITE_LOADER_INIT("lite", true, true),
        INIT("initialization"),
        POST_INIT("post_initialization"),
        LOAD_COMPLETE("completed"),
        FINAL_LOADING("reloading_resource_packs", true, false);

        private String translatedName = null;
        final String name;
        final boolean isLoneState;
        final boolean shouldSkip;

        private State(String name, boolean mods, boolean skip) {
            this.isLoneState = mods;
            this.name = name;
            this.shouldSkip = skip;
        }

        private State(String name) {
            this(name, false, false);
        }

        public String translate() {
            if (this.translatedName != null) {
                return this.translatedName;
            }
            String failure = this.name.replaceAll("\\_", " ");
            String[] split = failure.split(" ");
            failure = "";
            for (int i = 0; i < split.length; ++i) {
                failure = failure + (i == 0 ? "" : " ");
                failure = failure + split[i].substring(0, 1).toUpperCase().concat(split[i].substring(1));
            }
            this.translatedName = Translation.translate("betterloadingscreen.state." + this.name, failure);
            return this.translatedName;
        }
    }
}

