/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.registry;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import me.otho.customItems.configuration.jsonReaders.tileEntity.Cfg_chest;
import me.otho.customItems.mod.blocks.CustomChest;
import me.otho.customItems.mod.materials.CI_Material;
import me.otho.customItems.registry.Registry;
import me.otho.customItems.utility.LogHelper;
import me.otho.customItems.utility.Util;
import net.minecraft.block.Block;
import org.apache.logging.log4j.Level;

public class TileEntityRegistry {
    public static boolean registerChest(Cfg_chest data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        data.toolClass = Util.validateToolClass(data.toolClass);
        CustomChest block = new CustomChest(CI_Material.getMaterial(data.material), data.invWidth, data.invHeight, data.invName);
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.func_149715_a(data.lightLevel);
        block.setHarvestLevel(data.toolClass, data.harvestLevel);
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        block.setHasOwner(data.hasOwner);
        if (data.slotMaxStackSize < 0) {
            data.slotMaxStackSize = 0;
        }
        if (data.slotMaxStackSize > 64) {
            data.slotMaxStackSize = 64;
        }
        block.setSlotMaxStackSize(data.slotMaxStackSize);
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c("customitems".toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        return false;
    }

    public static boolean registerChest(Cfg_chest[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = TileEntityRegistry.registerChest(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Chest " + i);
            return false;
        }
        return true;
    }
}

