/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.registry;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.HashMap;
import me.otho.customItems.compability.NEICustomItemsConfig;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_block;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_blockDrop;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_crop;
import me.otho.customItems.configuration.jsonReaders.blocks.Cfg_fluid;
import me.otho.customItems.configuration.jsonReaders.common.Cfg_drop;
import me.otho.customItems.mod.blocks.CustomBlock;
import me.otho.customItems.mod.blocks.CustomCrop;
import me.otho.customItems.mod.blocks.CustomFallingBlock;
import me.otho.customItems.mod.blocks.CustomFenceBlock;
import me.otho.customItems.mod.blocks.CustomFluidBlock;
import me.otho.customItems.mod.blocks.CustomPaneBlock;
import me.otho.customItems.mod.blocks.CustomRotatedPillar;
import me.otho.customItems.mod.blocks.CustomSlabBlock;
import me.otho.customItems.mod.blocks.CustomStairsBlock;
import me.otho.customItems.mod.blocks.CustomWallBlock;
import me.otho.customItems.mod.handler.BucketHandler;
import me.otho.customItems.mod.items.CustomBucket;
import me.otho.customItems.mod.items.CustomSeed;
import me.otho.customItems.mod.items.CustomSlabItem;
import me.otho.customItems.mod.materials.CI_Material;
import me.otho.customItems.registry.Registry;
import me.otho.customItems.utility.LogHelper;
import me.otho.customItems.utility.Util;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;

public class BlockRegistry {
    public static HashMap<String, Cfg_blockDrop> drops = new HashMap();

    public static boolean registerBlockDrop(Cfg_blockDrop data) {
        String[] parser = data.id.split(":");
        if (parser.length < 3) {
            data.id = data.id.concat(":0");
        }
        if (drops.containsKey(data.id)) {
            Cfg_blockDrop drop = drops.get(data.id);
            drop.drops = (Cfg_drop[])ArrayUtils.addAll((Object[])drop.drops, (Object[])data.drops);
            drops.replace(data.id, drop);
        } else {
            drops.put(data.id, data);
        }
        return true;
    }

    public static boolean registerBlockDrop(Cfg_blockDrop[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = BlockRegistry.registerBlockDrop(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Entity drop " + i);
            return false;
        }
        return true;
    }

    public static boolean registerBlock(Cfg_block data) {
        LogHelper.log(Level.INFO, "Register Block: " + data.name, 1);
        data.toolClass = Util.validateToolClass(data.toolClass);
        if (Util.validateType(data.type)) {
            Util.BlockType blockType = Util.BlockType.valueOf(data.type.toUpperCase());
            switch (blockType) {
                case FENCE: {
                    BlockRegistry.registerFenceBlock(data);
                    break;
                }
                case LOG: 
                case PILLARS: {
                    BlockRegistry.registerLogBlock(data);
                    break;
                }
                case PANE: {
                    BlockRegistry.registerPaneBlock(data);
                    break;
                }
                case SLAB: {
                    BlockRegistry.registerSlabBlock(data);
                    break;
                }
                case STAIRS: {
                    BlockRegistry.registerStairsBlock(data);
                    break;
                }
                case WALL: {
                    BlockRegistry.registerWallBlock(data);
                    break;
                }
                case FALLING: {
                    BlockRegistry.registerFallingBlock(data);
                    break;
                }
                default: {
                    BlockRegistry.registerNormalBlock(data);
                }
            }
        }
        return true;
    }

    public static void registerWallBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomWallBlock block = new CustomWallBlock(new CustomBlock(CI_Material.getMaterial(data.material)));
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.setBreaks(data.dropsItSelf);
        block.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        block.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            block.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            block.setDropItem(data.dropItemName);
            block.setMaxItemDrop(data.maxItemDrop);
            block.setMinItemDrop(data.minItemDrop);
            block.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)block);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
    }

    public static void registerStairsBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomStairsBlock block = new CustomStairsBlock(new CustomBlock(CI_Material.getMaterial(data.material)), 0);
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.setBreaks(data.dropsItSelf);
        block.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        block.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            block.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            block.setDropItem(data.dropItemName);
            block.setMaxItemDrop(data.maxItemDrop);
            block.setMinItemDrop(data.minItemDrop);
            block.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)block);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
    }

    public static void registerSlabBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomSlabBlock slabBlock = new CustomSlabBlock(false, CI_Material.getMaterial(data.material), registerName);
        slabBlock.func_149711_c(data.hardness);
        slabBlock.func_149752_b(data.resistance);
        slabBlock.setBreaks(data.dropsItSelf);
        slabBlock.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        slabBlock.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            slabBlock.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            slabBlock.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            slabBlock.registerBlockTextures(textureNames);
        }
        slabBlock.field_149765_K = data.slipperiness;
        slabBlock.setOpaque(data.isOpaque);
        slabBlock.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            slabBlock.setDropItem(data.dropItemName);
            slabBlock.setMaxItemDrop(data.maxItemDrop);
            slabBlock.setMinItemDrop(data.minItemDrop);
            slabBlock.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)slabBlock);
        Registry.blocksList.add(data.creativeTab);
        CustomSlabBlock doubleBlock = new CustomSlabBlock(true, CI_Material.getMaterial(data.material), registerName);
        doubleBlock.func_149711_c(data.hardness);
        doubleBlock.func_149752_b(data.resistance);
        doubleBlock.setBreaks(data.dropsItSelf);
        doubleBlock.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        doubleBlock.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            doubleBlock.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            doubleBlock.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            doubleBlock.registerBlockTextures(textureNames);
        }
        doubleBlock.field_149765_K = data.slipperiness;
        doubleBlock.setOpaque(data.isOpaque);
        doubleBlock.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            doubleBlock.setDropItem(data.dropItemName);
            doubleBlock.setMaxItemDrop(data.maxItemDrop);
            doubleBlock.setMinItemDrop(data.minItemDrop);
            doubleBlock.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        GameRegistry.registerBlock((Block)slabBlock, CustomSlabItem.class, (String)registerName, (Object[])new Object[]{slabBlock, doubleBlock, false});
        slabBlock.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(slabBlock.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)slabBlock);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
        GameRegistry.registerBlock((Block)doubleBlock, CustomSlabItem.class, (String)("double_" + registerName), (Object[])new Object[]{slabBlock, doubleBlock, true});
        doubleBlock.func_149663_c(Registry.mod_id.toLowerCase() + ":" + "double_" + registerName);
        LanguageRegistry.instance().addStringLocalization(doubleBlock.func_149739_a() + ".name", "en_US", data.name);
        itemBlock = Item.func_150898_a((Block)slabBlock);
        size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
        NEICustomItemsConfig.addItemToHide(Registry.mod_id + ":double_" + registerName);
    }

    public static void registerPaneBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomPaneBlock block = new CustomPaneBlock("side", "top", Material.field_151592_s, true);
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.setBreaks(data.dropsItSelf);
        block.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        block.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            block.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            block.setDropItem(data.dropItemName);
            block.setMaxItemDrop(data.maxItemDrop);
            block.setMinItemDrop(data.minItemDrop);
            block.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)block);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
    }

    public static void registerFallingBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomFallingBlock block = new CustomFallingBlock(CI_Material.getMaterial(data.material));
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.setBreaks(data.dropsItSelf);
        block.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        block.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            block.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            block.setDropItem(data.dropItemName);
            block.setMaxItemDrop(data.maxItemDrop);
            block.setMinItemDrop(data.minItemDrop);
            block.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)block);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
    }

    public static void registerNormalBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomBlock block = new CustomBlock(CI_Material.getMaterial(data.material));
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.setBreaks(data.dropsItSelf);
        block.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        block.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            block.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            block.setDropItem(data.dropItemName);
            block.setMaxItemDrop(data.maxItemDrop);
            block.setMinItemDrop(data.minItemDrop);
            block.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)block);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
    }

    public static void registerLogBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomRotatedPillar block = new CustomRotatedPillar(CI_Material.getMaterial(data.material));
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.setBreaks(data.dropsItSelf);
        block.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        block.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            block.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            block.setDropItem(data.dropItemName);
            block.setMaxItemDrop(data.maxItemDrop);
            block.setMinItemDrop(data.minItemDrop);
            block.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)block);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
    }

    public static void registerFenceBlock(Cfg_block data) {
        String registerName = Util.parseRegisterName(data.name);
        CustomFenceBlock block = new CustomFenceBlock(data.textureName, CI_Material.getMaterial(data.material));
        block.func_149711_c(data.hardness);
        block.func_149752_b(data.resistance);
        block.setBreaks(data.dropsItSelf);
        block.setCanSilkHarvest(data.canSilkHarvest);
        data.lightLevel = Util.range(data.lightLevel, 0.0f, 1.0f);
        block.func_149715_a(data.lightLevel);
        if (data.toolClass != null) {
            block.setHarvestLevel(data.toolClass, data.harvestLevel);
        }
        if (data.multipleTextures == null) {
            block.func_149658_d(data.textureName);
        } else {
            String[] textureNames = new String[]{data.multipleTextures.yneg, data.multipleTextures.ypos, data.multipleTextures.zneg, data.multipleTextures.zpos, data.multipleTextures.xneg, data.multipleTextures.xpos};
            block.registerBlockTextures(textureNames);
        }
        block.field_149765_K = data.slipperiness;
        block.setOpaque(data.isOpaque);
        block.func_149672_a(Util.parseSoundType(data.stepSound));
        if (data.dropItemName != null) {
            block.setDropItem(data.dropItemName);
            block.setMaxItemDrop(data.maxItemDrop);
            block.setMinItemDrop(data.minItemDrop);
            block.setEachExtraItemDropChance(data.eachExtraItemDropChance);
        }
        Registry.blocksList.add((Object)block);
        Registry.blocksList.add(data.creativeTab);
        GameRegistry.registerBlock((Block)block, (String)registerName);
        block.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName);
        LanguageRegistry.instance().addStringLocalization(block.func_149739_a() + ".name", "en_US", data.name);
        Item itemBlock = Item.func_150898_a((Block)block);
        int size = Util.range(data.maxStackSize, 1, 64);
        itemBlock.func_77625_d(size);
    }

    public static boolean registerBlock(Cfg_block[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = BlockRegistry.registerBlock(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Block " + i);
            return false;
        }
        return true;
    }

    public static boolean registerCrop(Cfg_crop data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        int cropRender = data.renderType.equals("crops") ? 6 : (data.renderType.equals("flower") ? 1 : 6);
        CustomCrop crop = new CustomCrop(data.fruitName, cropRender);
        CustomSeed seed = new CustomSeed((Block)crop);
        crop.setSeed(seed);
        crop.setAcceptBoneMeal(data.acceptBoneMeal);
        crop.setDropSeedWhenMature(data.dropSeedWhenMature);
        crop.setEachExtraFruitDropChance(data.eachExtraFruitDropChance);
        crop.setEachExtraSeedDropChance(data.eachExtraSeedDropChance);
        crop.setFruitQuantityDropRange(data.minFruitDrop, data.maxFruitDrop);
        crop.setSeedQuantityDropRange(data.minSeedDrop, data.maxSeedDrop);
        crop.setFruitItemDamage(data.dropFruitDamage);
        crop.func_149658_d(data.textureName);
        seed.func_111206_d(data.textureName + "_seed");
        GameRegistry.registerBlock((Block)crop, (String)(registerName + "_crop"));
        crop.func_149663_c(Registry.mod_id.toLowerCase() + ":" + registerName + "_crop");
        LanguageRegistry.instance().addStringLocalization(crop.func_149739_a() + ".name", "en_US", data.name);
        GameRegistry.registerItem((Item)seed, (String)(registerName + "_seed"));
        seed.func_77655_b(Registry.mod_id.toLowerCase() + ":" + registerName + "_seed");
        LanguageRegistry.instance().addStringLocalization(seed.func_77658_a() + ".name", "en_US", data.name + " Seeds");
        Registry.itemsList.add((Object)seed);
        Registry.itemsList.add(data.creativeTab);
        if (data.dropFromGrassChance > 0) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack((Item)seed), (int)data.dropFromGrassChance);
        }
        NEICustomItemsConfig.addItemToHide(Registry.mod_id + ":" + registerName);
        return true;
    }

    public static boolean registerCrop(Cfg_crop[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = BlockRegistry.registerCrop(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Crop " + i);
            return false;
        }
        return true;
    }

    public static boolean registerFluid(Cfg_fluid data) {
        LogHelper.log(Level.INFO, data.name, 1);
        String registerName = Util.parseRegisterName(data.name);
        data.luminosity = Util.range(data.luminosity, 0, 15);
        Fluid fluid = new Fluid(registerName);
        fluid.setLuminosity(data.luminosity);
        fluid.setDensity(data.density);
        fluid.setTemperature(data.temperature);
        fluid.setViscosity(data.viscosity);
        fluid.setGaseous(data.isGas);
        FluidRegistry.registerFluid((Fluid)fluid);
        Material material = data.material.equals("lava") ? Material.field_151587_i : Material.field_151586_h;
        CustomFluidBlock fluidBlock = new CustomFluidBlock(fluid, material);
        fluidBlock.setQuantaPerBlock(data.flowLength);
        fluidBlock.func_149658_d(data.textureName);
        Registry.blocksList.add((Object)fluidBlock);
        Registry.blocksList.add(data.creativeTab);
        fluidBlock.func_149663_c(Registry.mod_id.toLowerCase() + ":" + data.name);
        GameRegistry.registerBlock((Block)fluidBlock, (String)registerName);
        fluid.setUnlocalizedName(fluidBlock.func_149739_a().substring(fluidBlock.func_149739_a().indexOf(":") + 1));
        LanguageRegistry.instance().addStringLocalization(fluidBlock.func_149739_a() + ".name", "en_US", data.name);
        LanguageRegistry.instance().addStringLocalization(fluid.getUnlocalizedName(), "en_US", data.name);
        fluid.setBlock((Block)fluidBlock);
        if (data.bucket.name == null) {
            data.bucket.name = data.name + " Bucket";
        }
        String BucketRegisterName = Util.parseRegisterName(data.bucket.name);
        if (data.bucket.creativeTab == null) {
            data.bucket.creativeTab = data.creativeTab;
        }
        if (data.bucket.textureName == null) {
            data.bucket.textureName = data.textureName + "_bucket";
        }
        CustomBucket bucket = new CustomBucket(fluidBlock, data.bucket.textureName);
        bucket.func_77655_b(Registry.mod_id.toLowerCase() + ":" + data.bucket.name);
        bucket.func_77642_a(Items.field_151133_ar);
        Registry.itemsList.add((Object)bucket);
        Registry.itemsList.add(data.bucket.creativeTab);
        bucket.func_111206_d(data.bucket.textureName);
        GameRegistry.registerItem((Item)bucket, (String)BucketRegisterName);
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)fluid.getName(), (int)1000), (ItemStack)new ItemStack((Item)bucket), (ItemStack)new ItemStack(Items.field_151133_ar));
        LanguageRegistry.instance().addStringLocalization(bucket.func_77658_a() + ".name", "en_US", data.bucket.name);
        BucketHandler.INSTANCE.buckets.put((Block)fluidBlock, (Item)bucket);
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.INSTANCE);
        return true;
    }

    public static boolean registerFluid(Cfg_fluid[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean registered = BlockRegistry.registerFluid(data[i]);
            if (registered) continue;
            LogHelper.error("Failed to register: Fluid " + i);
            return false;
        }
        return true;
    }
}

