/*
 * Decompiled with CFR 0.152.
 */
package me.otho.customItems.mod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import me.otho.customItems.CustomItems;
import me.otho.customItems.mod.tileentitys.TileEntityCustomChest;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CustomChest
extends Block
implements ITileEntityProvider {
    private int invWidth = 3;
    private int invHeight = 3;
    private String name = "Custom Chest";
    private boolean hasOwner = false;
    private int slotMaxStackSize = 64;
    private String[] textureNames;
    private IIcon[] icons = new IIcon[6];

    public CustomChest(Material material, int w, int h, String name) {
        super(material);
        this.invWidth = w <= 9 ? w : 9;
        this.invHeight = h <= 6 ? h : 6;
        this.name = name;
    }

    public void setOpaque(boolean isOpaque) {
        this.field_149787_q = isOpaque;
        this.field_149786_r = this.func_149662_c() ? 255 : 0;
    }

    public void setSlotMaxStackSize(int max) {
        this.slotMaxStackSize = max;
    }

    public void setHasOwner(boolean hasOwner) {
        this.hasOwner = hasOwner;
    }

    public boolean getHasOwner() {
        return this.hasOwner;
    }

    public int getInvWidth() {
        return this.invWidth;
    }

    public int getInvHeight() {
        return this.invHeight;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.field_149768_d != null) {
            return this.field_149761_L;
        }
        return this.icons[side];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        if (this.textureNames == null) {
            this.field_149761_L = iconRegister.func_94245_a("customitems".toLowerCase() + ":" + this.field_149768_d);
        } else {
            for (int i = 0; i < this.icons.length; ++i) {
                this.icons[i] = iconRegister.func_94245_a("customitems".toLowerCase() + ":" + this.textureNames[i]);
            }
        }
    }

    public void registerBlockTextures(String[] textureNames) {
        this.textureNames = textureNames;
    }

    public String func_149739_a() {
        return super.func_149739_a();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        TileEntityCustomChest customChest = new TileEntityCustomChest();
        customChest.setWidth(this.invWidth);
        customChest.setHeight(this.invHeight);
        customChest.setSlots();
        customChest.setName(this.name);
        customChest.setSlotMaxStackSize(this.slotMaxStackSize);
        return customChest;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149689_a(World p_149689_1_, int p_149689_2_, int p_149689_3_, int p_149689_4_, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        EntityPlayer player = (EntityPlayer)p_149689_5_;
        TileEntityCustomChest tile = (TileEntityCustomChest)p_149689_1_.func_147438_o(p_149689_2_, p_149689_3_, p_149689_4_);
        if (tile != null) {
            tile.registerOwner(player.func_110124_au().toString());
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TileEntityCustomChest tile = (TileEntityCustomChest)world.func_147438_o(x, y, z);
        if (tile == null || player.func_70093_af()) {
            return false;
        }
        if (!this.hasOwner || tile.getOwner().equals(player.func_110124_au().toString())) {
            player.openGui((Object)CustomItems.instance, 0, world, x, y, z);
            return true;
        }
        player.func_146105_b((IChatComponent)new ChatComponentText("You can't open what is not yours"));
        return false;
    }

    public void func_149749_a(World world, int p_149749_2_, int p_149749_3_, int p_149749_4_, Block p_149749_5_, int p_149749_6_) {
        TileEntityCustomChest tileentitychest = (TileEntityCustomChest)world.func_147438_o(p_149749_2_, p_149749_3_, p_149749_4_);
        if (tileentitychest != null) {
            for (int i1 = 0; i1 < tileentitychest.func_70302_i_(); ++i1) {
                ItemStack itemstack = tileentitychest.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = world.field_73012_v.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)p_149749_2_ + f), (double)((float)p_149749_3_ + f1), (double)((float)p_149749_4_ + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_);
        }
        super.func_149749_a(world, p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_, p_149749_6_);
    }
}

