/*
 * Decompiled with CFR 0.152.
 */
package com.Otho.customItems.handler;

import com.Otho.customItems.handler.ConfigurationHandler;
import com.Otho.customItems.mod.items.armor.CustomArmor;
import com.Otho.customItems.util.StringUtil;
import com.Otho.customItems.util.logHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.common.util.EnumHelper;

public class ArmorHandler {
    public static void init() {
        JsonObject armors = ConfigurationHandler.armor;
        if (armors != null) {
            JsonArray helmets = (JsonArray)armors.get("helmets");
            JsonArray chestplates = (JsonArray)armors.get("chestplates");
            JsonArray leggings = (JsonArray)armors.get("leggings");
            JsonArray boots = (JsonArray)armors.get("boots");
            if (helmets != null) {
                ArmorHandler.NewArmors(helmets, 0);
            }
            if (chestplates != null) {
                ArmorHandler.NewArmors(chestplates, 1);
            }
            if (leggings != null) {
                ArmorHandler.NewArmors(leggings, 2);
            }
            if (boots != null) {
                ArmorHandler.NewArmors(boots, 3);
            }
        }
    }

    private static void NewArmors(JsonArray armors, int type) {
        for (int i = 0; i < armors.size(); ++i) {
            JsonObject data = (JsonObject)armors.get(i);
            logHelper.log((String)"customItems", (String)logHelper.debug, (String)data.toString());
            String name = data.get("name").getAsString();
            String textureName = data.get("textureName").getAsString();
            textureName = StringUtil.parseTextureName((String)textureName);
            int durability = data.get("durability").getAsInt();
            int reductionNum = data.get("reduction").getAsInt();
            int enchantability = data.get("enchantability").getAsInt();
            int[] reduction = new int[]{0, 0, 0, 0};
            reduction[type] = reductionNum;
            ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)textureName, (int)durability, (int[])reduction, (int)enchantability);
            CustomArmor armor = new CustomArmor(material, 0, type, textureName);
            GameRegistry.registerItem((Item)armor, (String)(textureName + "_" + type));
            armor.setUnlocalizedName("customItems".toLowerCase() + ":" + name);
            LanguageRegistry.instance().addStringLocalization(armor.getUnlocalizedName() + ".name", "en_US", name.substring(0, 1).toUpperCase() + name.substring(1));
        }
    }
}

