/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage;
import cpw.mods.fml.common.network.handshake.IHandshakeState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import org.apache.logging.log4j.Level;

public class HandshakeMessageHandler<S extends Enum<S>>
extends SimpleChannelInboundHandler<FMLHandshakeMessage> {
    private static final AttributeKey<IHandshakeState<?>> STATE = new AttributeKey("fml:handshake-state");
    private final AttributeKey<S> fmlHandshakeState = STATE;
    private S initialState;
    private Class<S> stateType;

    public HandshakeMessageHandler(Class<S> stateType) {
        this.initialState = Enum.valueOf(stateType, "START");
        this.stateType = stateType;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FMLHandshakeMessage msg) throws Exception {
        Enum state = (Enum)ctx.attr(this.fmlHandshakeState).get();
        FMLLog.finer(msg.toString(this.stateType) + "->" + state.getClass().getName().substring(state.getClass().getName().lastIndexOf(46) + 1) + ":" + state, new Object[0]);
        Enum newState = (Enum)((IHandshakeState)((Object)state)).accept(ctx, msg);
        ctx.attr(this.fmlHandshakeState).set((Object)newState);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.attr(this.fmlHandshakeState).set(this.initialState);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        Enum state = (Enum)ctx.attr(this.fmlHandshakeState).get();
        Enum newState = (Enum)((IHandshakeState)((Object)state)).accept(ctx, null);
        ctx.attr(this.fmlHandshakeState).set((Object)newState);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log(Level.ERROR, cause, "HandshakeMessageHandler exception", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

